﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PaymentLink;

namespace Farakonesh.API.Controllers.App.Order.PaymentLink
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class PaymentLinkController : ControllerBase
    {
        private readonly IPaymentLinkContext _ctx;

        public PaymentLinkController(IPaymentLinkContext ctx)
        {
            _ctx = ctx;
        }

        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] GetPaymentLink.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetPaymentLink(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_PaymentLink.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_PaymentLink(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_PaymentLink.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_PaymentLink(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpDelete]
        public async Task<IActionResult> Delete([FromBody] Delete_PaymentLink.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_PaymentLink(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
