﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PaymentLink;
using System.Threading.Tasks;
using System.Threading;

namespace Farakonesh.API.Controllers.App.Order.PaymentLink
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class PaymentLinkHistoryController : ControllerBase
    {
        private readonly IPaymentLinkContext _ctx;

        public PaymentLinkHistoryController(IPaymentLinkContext ctx)
        {
            _ctx = ctx;
        }

        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] GetPaymentLinkHistory.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetPaymentLinkHistory(inputs, cancellationToken);
            return Ok(rst);
        }

      
        [HttpDelete]
        public async Task<IActionResult> Delete([FromBody] Delete_PaymentLinkHistory.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_PaymentLinkHistory(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
