﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Paypal;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PremiumAccount;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.Paypal
{
    /// <summary>
    /// سرویس های کار با شارژ حساب پی پال
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class OrderPaypalChargeController : ControllerBase
    {
        private readonly IPaypalContext _ctx;
        public OrderPaypalChargeController(
IPaypalContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت اطلاعات سفارش پی پال - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetAll([FromBody] GetOrder_PaypalCharge.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrder_PaypalCharge(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات سفارش پی پال - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAllByAdmin([FromBody] GetOrder_PaypalChargeByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrder_PaypalChargeByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت قیمت سفارش
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetPrice([FromBody] Get_OrderPaypalCharge_Price.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_OrderPaypalCharge_Price(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش پی پال - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> Save([FromBody] Insert_OrderPaypalChargeByCustomer.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderPaypalChargeByCustomer(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش پی پال - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveByAdmin([FromBody] Insert_OrderPaypalChargeByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderPaypalChargeByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش شارژ پی پال - سمت کمپانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> SaveByCompany([FromBody] Insert_OrderPaypalChargeByCompany.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderPaypalChargeByCompany(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
