﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Commands.Services;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IServices.IApp.IOrder;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.App;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PerfectMoney;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.PerfectMoney
{
    /// <summary>
    /// سرویس کار با سفارش شارژ پرفکت مانی
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class OrderPerfectMoneyChargeController : ControllerBase
    {
        private readonly IPerfectMoneyContext _ctx;
        public OrderPerfectMoneyChargeController(
IPerfectMoneyContext ctx)
        {
            _ctx = ctx;

        }
        /// <summary>
        /// دریافت اطلاعات شارژ پرفکت مانی - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetAll([FromBody] GetOrder_PerfectMoneyCharge.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrder_PerfectMoneyCharge(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات شارژ پرفکت مانی - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAllByAdmin([FromBody] GetOrder_PerfectMoneyChargeByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrder_PerfectMoneyChargeByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت قیمت سفارش
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetPrice([FromBody] Get_OrderPerfectMoneyCharge_Price.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_OrderPerfectMoneyCharge_Price(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش جدید - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> Save([FromBody] Insert_OrderPerfectMoneyChargeByCustomer.Inputs inputs, CancellationToken cancellationToken)
        {

            var rst = await _ctx.Insert_OrderPerfectMoneyChargeByCustomer(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش شارژ پرفکت مانی - سمت کمپانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CompanyAuth]
        public async Task<IActionResult> SaveByCompany([FromBody] Insert_OrderPerfectMoneyChargeByCompany.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderPerfectMoneyChargeByCompany(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش جدید - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveByAdmin([FromBody] Insert_OrderPerfectMoneyChargeByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderPerfectMoneyChargeByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }

      
    }
}
