﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Commands.Services;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IServices.IApp.IOrder;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.App;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PerfectMoney;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.PerfectMoney
{
    /// <summary>
    /// سرویس های کار با سفارش فروش پرفکت مانی
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class OrderPerfectMoneySellController : ControllerBase
    {
        private readonly IPerfectMoneyContext _ctx;
        public OrderPerfectMoneySellController(
IPerfectMoneyContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت اطلاعات سفارش - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetAll([FromBody] GetOrder_PerfectMoneySell.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrder_PerfectMoneySell(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات سفارش - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAllByAdmin([FromBody] GetOrder_PerfectMoneySellByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrder_PerfectMoneySellByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات سفارش - سمت مشتری - بدون نیاز به امضای کاربری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> GetAllAnonymous([FromBody] GetOrder_PerfectMoneySellAnonymous.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrder_PerfectMoneySellAnonymous(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت قیمت سفارش
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetPrice([FromBody] Get_OrderPerfectMoneySell_Price.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_OrderPerfectMoneySell_Price(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// ثبت سفارش جدید - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> Save([FromBody] Insert_OrderPerfectMoneySellByCustomer.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderPerfectMoneySellByCustomer(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش جدید - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveByAdmin([FromBody] Insert_OrderPerfectMoneySellByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderPerfectMoneySellByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش فروش پرفکت مانی - سمت کمپانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> SaveByCompany([FromBody] Insert_OrderPerfectMoneySellByCompany.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderPerfectMoneySellByCompany(inputs, cancellationToken);
            return Ok(rst);
        }


    }
}
