﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Commands.Services;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IServices.IApp.IOrder;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.App;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PerfectMoney;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.PerfectMoney
{
    /// <summary>
    /// سرویس های کار با خرید ووچر پرفکت مانی
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class OrderPerfectMoneyVoucherController : ControllerBase
    {
        private readonly IPerfectMoneyContext _ctx;
        public OrderPerfectMoneyVoucherController(
IPerfectMoneyContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت اطلاعات سفارش ووچر پرفکت مانی - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetAll([FromBody] GetOrder_PerfectMoneyVoucher.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrder_PerfectMoneyVoucher(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات سفارش ووچر پرفکت مانی - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAllByAdmin([FromBody] GetOrder_PerfectMoneyVoucherByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrder_PerfectMoneyVoucherByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت مبلغ سفارش
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetPrice([FromBody] Get_OrderPerfectMoneyVoucher_Price.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_OrderPerfectMoneyVoucher_Price(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش جدید - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> Save([FromBody] Insert_OrderPerfectMoneyVoucherByCustomer.Inputs inputs, CancellationToken cancellationToken)
        {

            var rst = await _ctx.Insert_OrderPerfectMoneyVoucherByCustomer(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش جدید - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveByAdmin([FromBody] Insert_OrderPerfectMoneyVoucherByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {

            var rst = await _ctx.Insert_OrderPerfectMoneyVoucherByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش خرید ووچر - سمت کمپانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> SaveByCompany([FromBody] Insert_OrderPerfectMoneyVoucherByCompany.Inputs inputs, CancellationToken cancellationToken)
        {

            var rst = await _ctx.Insert_OrderPerfectMoneyVoucherByCompany(inputs, cancellationToken);
            return Ok(rst);
        }
        
    }
}
