﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Commands.Services;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IServices.IApp.IOrder;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.App;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PerfectMoney;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.PerfectMoney
{
    /// <summary>
    /// سرویس های کار با فروش ووچر پرفکت مانی
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class OrderVoucherPerfectMoneySellController : ControllerBase
    {
        private readonly IPerfectMoneyContext _ctx;
        public OrderVoucherPerfectMoneySellController(
IPerfectMoneyContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت اطلاعات سفارش - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetAll([FromBody] GetOrder_VoucherPerfectMoneySell.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrder_VoucherPerfectMoneySell(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات سفارش - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAllByAdmin([FromBody] GetOrder_VoucherPerfectMoneySellByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrder_VoucherPerfectMoneySellByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت مبلغ سفارش
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetPrice([FromBody] Get_OrderVoucherPerfectMoneySell_Price.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_OrderVoucherPerfectMoneySell_Price(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش فروش ووچر پرفکت مانی - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> Save([FromBody] Insert_OrderVoucherPerfectMoneySellByCustomer.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderVoucherPerfectMoneySellByCustomer(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش فروش ووچر پرفکت مانی - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveByAdmin([FromBody] Insert_OrderVoucherPerfectMoneySellByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderVoucherPerfectMoneySellByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        
        /// <summary>
        /// ثبت سفارش فروش ووچر - سمت کمپانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CompanyAuth]
        public async Task<IActionResult> SaveByCompany([FromBody] Insert_OrderVoucherPerfectMoneySellByCompany.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderVoucherPerfectMoneySellByCompany(inputs, cancellationToken);
            return Ok(rst);
        }

    }
}
