﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PremiumAccount;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.PremiumAccount
{
    /// <summary>
    /// سرویس های کار با انواع فعال سازی حساب
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ActivationTypePremiumAccountController : ControllerBase
    {
        private readonly IPremiumAccountContext _ctx;
        public ActivationTypePremiumAccountController(IPremiumAccountContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست انواع فعال سازی حساب
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> Get([FromBody] GetActivationTypePremiumAccountList.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetActivationTypePremiumAccountList(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// ایجاد یک نوع جدید - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_ActivationTypePremiumAccount.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_ActivationTypePremiumAccount(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی نوع - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_ActivationTypePremiumAccount.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_ActivationTypePremiumAccount(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف نوع - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_ActivationTypePremiumAccount.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_ActivationTypePremiumAccount(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
