﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PremiumAccount;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.PremiumAccount
{
    /// <summary>
    /// سرویس های کار با ریجن ها و کشور ها
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class CountryPremiumAccountController : ControllerBase
    {
        private readonly IPremiumAccountContext _ctx;
        public CountryPremiumAccountController(IPremiumAccountContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت ریجن و کشورها
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> Get([FromBody] GetCountryPremiumAccountList.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetCountryPremiumAccountList(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// ایجاد یک ریجن و کشور جدید
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_CountryPremiumAccount.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_CountryPremiumAccount(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی ریجن و کشور
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_CountryPremiumAccount.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_CountryPremiumAccount(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف ریجن و کشور
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_CountryPremiumAccount.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_CountryPremiumAccount(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
