﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Commands.Services.Order;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IServices.IApp.IOrder;
using Farakonesh.Logic.Services.App.Order.PremiumAccount;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PremiumAccount;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.PremiumAccount
{
    /// <summary>
    /// کار با سرویس مربوط به خرید اکانت پرمیوم
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class FullPremiumAccountController : ControllerBase
    {
        private readonly IPremiumAccountContext _premiumAccountContext;
        public FullPremiumAccountController(IPremiumAccountContext premiumAccountContext)
        {
            _premiumAccountContext = premiumAccountContext;
        }
        /// <summary>
        /// دریافت لیست کامل ملزومات حساب پرمیوم
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> Get([FromBody] GetFullPremiumAccount.Inputs command, CancellationToken cancellationToken)
        {
            var rst = await _premiumAccountContext.GetFullPremiumAccount(command, cancellationToken);
            return Ok(rst);
        }
    }
}
