﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PremiumAccount;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.PremiumAccount
{
    /// <summary>
    /// کار با سرویس های زبان در حساب پرمیوم
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class LanguagePremiumAccountController : ControllerBase
    {
        private readonly IPremiumAccountContext _ctx;
        public LanguagePremiumAccountController(IPremiumAccountContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست زبان ها
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> Get([FromBody] GetLanguagePremiumAccountList.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetLanguagePremiumAccountList(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// ثبت یک زبان جدید
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_LanguagePremiumAccount.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_LanguagePremiumAccount(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی زبان
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_LanguagePremiumAccount.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_LanguagePremiumAccount(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف زبان
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_LanguagePremiumAccount.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_LanguagePremiumAccount(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
