﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PremiumAccount;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.PremiumAccount
{
    /// <summary>
    /// کار با سرویس های پلن مربوط به حساب پرمیوم
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class PelanPremiumAccountController : ControllerBase
    {
        private readonly IPremiumAccountContext _ctx;
        public PelanPremiumAccountController(IPremiumAccountContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست پلن ها
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> Get([FromBody] GetPelanPremiumAccountList.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetPelanPremiumAccountList(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// ثبت یک پلن جدید
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_PelanPremiumAccount.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_PelanPremiumAccount(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز سانی پلن
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_PelanPremiumAccount.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_PelanPremiumAccount(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف پلن
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_PelanPremiumAccount.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_PelanPremiumAccount(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
