﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PremiumAccount;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.PremiumAccount
{
    /// <summary>
    /// کار با سرویس های نوع حساب پرمیوم
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class TypePremiumAccountController : ControllerBase
    {
        private readonly IPremiumAccountContext _ctx;
        public TypePremiumAccountController(IPremiumAccountContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت نوع حساب پرمیوم
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> Get([FromBody] GetTypePremiumAccountList.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetTypePremiumAccountList(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// ثبت نوع حساب پرمیوم جدید
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_TypePremiumAccount.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_TypePremiumAccount(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی حساب پرمیوم
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_TypePremiumAccount.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_TypePremiumAccount(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف حساب پرمیوم
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_TypePremiumAccount.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_TypePremiumAccount(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
