﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Scenario;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.Scenario
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ScenarioController : ControllerBase
    {
        private readonly IScenarioContext _ctx;
        public ScenarioController(
IScenarioContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست سناریو های ثبت شده - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAllByAdmin([FromBody] GetScenarioByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetScenarioByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست سناریو ها - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetAll([FromBody] GetScenario.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetScenario(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سناریوی سفارش توسط ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveByAdmin([FromBody] InsertScenario.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.InsertScenario(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت گروهی سناریو توسط ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveByAdminGroup([FromBody] InsertScenarioOrderTypeList.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.InsertScenarioOrderTypeList(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی سناریوی سفارش توسط ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> UpdateByAdmin([FromBody] UpdateScenario.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.UpdateScenario(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف سناریو - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] DeleteScenario.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.DeleteScenario(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
