﻿using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Scenario;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading.Tasks;
using System.Threading;

namespace Farakonesh.API.Controllers.App.Order.Scenario
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ScenarioGroupController : ControllerBase
    {
        private readonly IScenarioContext _ctx;
        public ScenarioGroupController(
IScenarioContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست گروه سناریوها - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAllByAdmin([FromBody] GetScenarioGroupByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetScenarioGroupByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
       
        /// <summary>
        /// ثبت گروه سناریو توسط ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveByAdmin([FromBody] InsertScenarioGroup.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.InsertScenarioGroup(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی سناریو توسط ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> UpdateByAdmin([FromBody] UpdateScenarioGroup.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.UpdateScenarioGroup(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف سناریو - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] DeleteScenarioGroup.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.DeleteScenarioGroup(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
