﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.VirtualServers;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.VirtualServers
{
    /// <summary>
    /// کار با سرویس های سفارش تمدید سرور مجازی
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class OrderVirtualAccountRenewalServersController : ControllerBase
    {
        private readonly IVirtualServerContext _ctx;
        public OrderVirtualAccountRenewalServersController(
IVirtualServerContext ctx)
        {
            _ctx = ctx;
        }

        /// <summary>
        /// دریافت مبلغ سفارش
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetPrice([FromBody] Get_OrderVirtualServers_AccountRenewal_Price.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_OrderVirtualServers_AccountRenewal_Price(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// ثبت سفارش جدید - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> Save([FromBody] Insert_OrderVirtualServerAccountRenewalByCustomer.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderVirtualServerAccountRenewalByCustomer(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش جدید تمدید سرور مجازی - سمت کمپانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CompanyAuth]
        public async Task<IActionResult> SaveByCompany([FromBody] Insert_OrderVirtualServerAccountRenewalByCompany.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderVirtualServerAccountRenewalByCompany(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش جدید - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveByAdmin([FromBody] Insert_OrderVirtualServerAccountRenewalByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderVirtualServerAccountRenewalByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
