﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.VirtualServers;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.VirtualServers
{
    /// <summary>
    /// کار با سرویس های خرید سرور مجازی
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class OrderVirtualServersController : ControllerBase
    {
        private readonly IVirtualServerContext _ctx;
        public OrderVirtualServersController(
IVirtualServerContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت اطلاعات سفارش - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetAll([FromBody] GetOrder_VirtualServers.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrder_VirtualServers(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات سفارش - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAllByAdmin([FromBody] GetOrder_VirtualServersByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrder_VirtualServersByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت مبلغ سفارش
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetPrice([FromBody] Get_OrderVirtualServers_Price.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_OrderVirtualServers_Price(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// ثبت سفارش جدید - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> Save([FromBody] Insert_OrderVirtualServerByCustomer.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderVirtualServerByCustomer(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش جدید سرور مجازی - سمت کمپانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CompanyAuth]
        public async Task<IActionResult> SaveByCompany([FromBody] Insert_OrderVirtualServerByCompany.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderVirtualServerByCompany(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش جدید - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveByAdmin([FromBody] Insert_OrderVirtualServerByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderVirtualServerByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی اطلاعات سفارش خریداری شده برای مشتری - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_OrderVirtualServerByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_OrderVirtualServerByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
