﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.VirtualServers
{
    /// <summary>
    /// سرویس کار با بازه ی زمانی سرور
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ServerPeriodController : ControllerBase
    {
        private readonly IRamRegionServerContext _ctx;
        public ServerPeriodController(
IRamRegionServerContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست بازه های زمانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetAll([FromBody] GetPeriodServer.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetPeriodServer(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت بازه ی زمانی جدید
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_ServerPeriod.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_ServerPeriod(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی بازه ی زمانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_ServerPeriod.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_ServerPeriod(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف بازه ی زمانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_ServerPeriod.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_ServerPeriod(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
