﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.VirtualServers
{
    /// <summary>
    /// سرویس کار با رم سرور
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ServerRamController : ControllerBase
    {
        private readonly IRamRegionServerContext _ctx;
        public ServerRamController(
IRamRegionServerContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست رم های سرور
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetAll([FromBody] GetRamServer.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetRamServer(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت رم سرور جدید
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_ServerRam.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_ServerRam(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی رم سرور
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_ServerRam.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_ServerRam(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف رم سرور
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_ServerRam.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_ServerRam(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
