﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.VirtualServers
{
    /// <summary>
    /// سرویس کار با لوکیشن سرور
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ServerRegionController : ControllerBase
    {
        private readonly IRamRegionServerContext _ctx;
        public ServerRegionController(
IRamRegionServerContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست لوکیشن ها
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] GetRegionServer.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetRegionServer(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// ثبت یک لوکیشن جدید
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_ServerRegion.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_ServerRegion(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی لوکیشن
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_ServerRegion.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_ServerRegion(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف لوکیشن
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_ServerRegion.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_ServerRegion(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
