﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.VirtualServers
{
    /// <summary>
    /// سرویس کار با انتصابات لوکیشن و رم سرور
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ServerRegionRamController : ControllerBase
    {
        private readonly IRamRegionServerContext _ctx;
        public ServerRegionRamController(
IRamRegionServerContext ctx)
        {
            _ctx = ctx;
        }

        /// <summary>
        /// دریافت لیست انتصابات لوکیشن و رم سرور
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetAll([FromBody] GetRegionServerByRamId.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetRegionServerByRamId(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// انتصاب لوکیشن به رم
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_ServerRegionRam.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_ServerRegionRam(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف انتصاب لوکیشن از رم
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_ServerRegionRam.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_ServerRegionRam(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
