﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Wise;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.Wise
{
    /// <summary>
    /// سرویس کار با سفارش شارژ حساب وایز
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class OrderWiseAccountChargeController : ControllerBase
    {
        private readonly IWiseContext _ctx;
        public OrderWiseAccountChargeController(
IWiseContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت سفارش وایز - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetAll([FromBody] GetOrder_WiseAccountCharge.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrder_WiseAccountCharge(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// دریافت سفارش وایز - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAllByAdmin([FromBody] GetOrder_WiseAccountChargeByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrder_WiseAccountChargeByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت قیمت سفارش
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetPrice([FromBody] Get_OrderWiseAccountCharge_Price.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_OrderWiseAccountCharge_Price(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// ثبت سفارش جدید وایز - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> Save([FromBody] Insert_OrderWiseAccountChargeByCustomer.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderWiseAccountChargeByCustomer(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش جدید وایز - سمت کمپانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CompanyAuth]
        public async Task<IActionResult> SaveByCompany([FromBody] Insert_OrderWiseAccountChargeByCompany.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderWiseAccountChargeByCompany(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش جدید وایز سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveByAdmin([FromBody] Insert_OrderWiseAccountChargeByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderWiseAccountChargeByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
