﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Wise;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.Wise
{
    /// <summary>
    /// سرویس کار با سفارش فروش وایز
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class OrderWiseSellController : ControllerBase
    {
        private readonly IWiseContext _ctx;
        public OrderWiseSellController(
IWiseContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت اطلاعات سفارش فروش وایز
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetAll([FromBody] GetOrder_WiseSell.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrder_WiseSell(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات فروش وایز سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAllByAdmin([FromBody] GetOrder_WiseSellByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrder_WiseSellByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت مبلغ سفارش
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetPrice([FromBody] Get_OrderWiseSell_Price.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_OrderWiseSell_Price(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// ثبت سفارش فروش جدید - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> Save([FromBody] Insert_OrderWiseSellByCustomer.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderWiseSellByCustomer(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش فروش جدید - سمت کمپانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CompanyAuth]
        public async Task<IActionResult> SaveByCompany([FromBody] Insert_OrderWiseSellByCompany.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderWiseSellByCompany(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش فروش جدید - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveByAdmin([FromBody] Insert_OrderWiseSellByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderWiseSellByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی اطلاعات فروش - پس از تکمیل عملیات انتقال یکسری اطلاعات باید بصورت دستی و یا بصورت اتوماتیک در سفارش بنشیند
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> Update([FromBody] Update_OrderWiseSellByCustomer.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_OrderWiseSellByCustomer(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
