﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Queue
{
    /// <summary>
    /// سرویس های سوابق ارسال آلارم
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class AlarmHistoryController : ControllerBase
    {
        private readonly IQueueContext _queueContext;
        public AlarmHistoryController(IQueueContext queueContext)
        {
            _queueContext = queueContext;
        }
        /// <summary>
        /// حذف سوابق ارسال آلارم
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_Alarm_User.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _queueContext.Delete_Alarm_User(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
