﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Queue
{
    /// <summary>
    /// سرویس های تنظیم آلارم برای اپراتور ها
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class AlarmsController : ControllerBase
    {
        private readonly IQueueContext _queueContext;
        public AlarmsController(IQueueContext queueContext)
        {
            _queueContext = queueContext;
        }
        /// <summary>
        /// دریافت لیست اپراتور هایی که قرار است آلارم های سیستم را دریافت کنند
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Get([FromBody] Get_Alarms.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _queueContext.Get_Alarms(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت یک اپراتور جدید که قرار است آلارم ها را دریافت کند
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_Alarm.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _queueContext.Insert_Alarm(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی تنظیمات آلارم برای یک اپراتور
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_Alarm.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _queueContext.Update_Alarm(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف تنظیمات آلارم برای یک اپراتور
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_Alarm.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _queueContext.Delete_Alarm(inputs, cancellationToken);
            return Ok(rst);
        }
        
    }
}
