﻿using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Logic.IServices.IApp.IQueue;

namespace Farakonesh.API.Controllers.App.Queue
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class CalendarController : ControllerBase
    {
        private readonly IQueueContext _ctx;
        private readonly ICalendarService _calendarService;
        public CalendarController(IQueueContext ctx,
            ICalendarService calendarService)
        {
            _ctx = ctx;
            _calendarService = calendarService;
        }
        [HttpGet]
        public async Task<IActionResult> SaveByCalendar([FromQuery] string year, CancellationToken cancellationToken)
        {
            await _calendarService.saveCalendar(year , cancellationToken);
            return Ok();
        }

        [HttpPut]
        public async Task<IActionResult> Get([FromBody] Get_Calendar.Inputs inputs, CancellationToken cancellationToken)
        {
            return Ok(await _ctx.Get_Calendar(inputs, cancellationToken));
        }
    }
}
