﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Commands.Services.Queue;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.App;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Queue
{
    /// <summary>
    /// کار با سرویس های سابقه ی چت های انجام شده
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class QueueChatController : ControllerBase
    {
        private readonly IQueueContext _ctx;
        private readonly IChatService _chatService;
        public QueueChatController(IQueueContext ctx,
            IChatService chatService)
        {
            _ctx = ctx;
            _chatService = chatService;
        }
        /// <summary>
        /// دریافت سابقه ی چت های انجام شده - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] Get_Chat.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_Chat(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات کامل یک صفحه ی چت با شناسه ی آن - سمت ادمین
        /// </summary>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetChatHistory([FromBody]GetChatHistoryCommand command, CancellationToken cancellationToken)
        {
            var rst = await _chatService.getChat(command, cancellationToken);
            return Ok(rst);
        }
    }
}
