﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.Services.App;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.API.Filters;

namespace Farakonesh.API.Controllers.App.Queue
{
    /// <summary>
    /// سرویس های کار با سابقه ی ایمیل ها
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class QueueEmailController : ControllerBase
    {
        private readonly IQueueContext _ctx;
        private readonly IConfiguration _configuration;
        public QueueEmailController(IQueueContext ctx, IConfiguration configuration)
        {
            _ctx = ctx;
            _configuration = configuration;
        }
        /// <summary>
        /// دریافت لیست سابقه ی ایمیل های ارسال شده
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] Get_Emails.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_Emails(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpPost]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> SaveMail([FromBody] Insert_Email.Inputs inputs, CancellationToken cancellationToken)
        {
            
            var rst = await _ctx.Insert_Email(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> UpdateMail([FromBody] Update_Email.Inputs inputs, CancellationToken cancellationToken)
        {
            
            var rst = await _ctx.Update_Email(inputs, cancellationToken);
            return Ok(rst);
        }

    }
}
