﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Farakonesh.Commands.Services.Queue;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IServices.IApp.ISms;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.API.Filters;
using StackExchange.Redis;
using Farakonesh.Logic.IServices.IApp.IQueue;

namespace Farakonesh.API.Controllers.App.Queue
{
    /// <summary>
    /// کار با سرویس های سابقه پیام رسان
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class QueueMessengersController : ControllerBase
    {
        private readonly IQueueContext _ctx;
        private readonly IQueueMessengersService _queueMessengersService;
        public QueueMessengersController(IQueueContext ctx,
            IQueueMessengersService queueMessengersService)
        {
            _ctx = ctx;
            _queueMessengersService = queueMessengersService;
        }
        /// <summary>
        /// دریافت سوابق ارسال به پیام رسان - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] Get_Messengers.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_Messengers(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// جهت اتصال به پیام رسان
        /// </summary>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> Connect(CancellationToken cancellationToken)
        {
            var rst = await _queueMessengersService.RequestConnect(cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// جهت حذف اتصال از تلگرام
        /// </summary>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpDelete]
        [CustomersAuth]
        public async Task<IActionResult> Disconnect([FromQuery] Disconnect_To_MessengersByCustomer.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Disconnect_To_MessengersByCustomer(inputs,cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// ثبت سابقه ارسال به پیام رسان
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        /// <exception cref="InternalServiceException"></exception>
        [HttpPost]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> SaveMessengers([FromBody] Insert_Messengers.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Messengers(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی سابقه ارسال به پیام رسان
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        /// <exception cref="InternalServiceException"></exception>
        [HttpPut]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> UpdateMessengers([FromBody] Update_Messengers.Inputs inputs, CancellationToken cancellationToken)
        {
            
            var rst = await _ctx.Update_Messengers(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
