﻿using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Queue
{
    [Route("api/[controller]")]
    [ApiController]
    public class QueuePaymentController : ControllerBase
    {
        private readonly IQueueContext _ctx;
        private readonly IConfiguration _configuration;
        public QueuePaymentController(IQueueContext ctx, IConfiguration configuration)
        {
            _ctx = ctx;
            _configuration = configuration;
        }
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] Get_Payment.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_Payment(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
