﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Farakonesh.Commands.Services.Queue;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IServices.IApp.ISms;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.App;
using Farakonesh.Logic.Services.App.Sms;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.API.Filters;

namespace Farakonesh.API.Controllers.App.Queue
{
    /// <summary>
    /// کار با سرویس های سابقه پیامک
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class QueueSmsController : ControllerBase
    {
        private readonly IQueueContext _ctx;
        private readonly ISmsService _ISmsService;
        private readonly IConfiguration _configuration;
        public QueueSmsController(IQueueContext ctx, ISmsService ISmsService, IConfiguration configuration)
        {
            _ctx = ctx;
            _ISmsService = ISmsService;
            _configuration = configuration;
        }
        /// <summary>
        /// دریافت سوابق ارسال پیامک - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] Get_SMS.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_SMS(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات کامل یک پیامک ارسال شده با شناسه پیامک - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetHistoryById([FromBody] HistorySmsCommand command, CancellationToken cancellationToken)
        {
            var rst = await _ISmsService.getSms(command, cancellationToken);
            return Ok(rst);
        }

        [HttpPost]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> SaveSms([FromBody] Insert_Sms.Inputs inputs, CancellationToken cancellationToken)
        {
            
            var rst = await _ctx.Insert_Sms(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> UpdateSms([FromBody] Update_Sms.Inputs inputs, CancellationToken cancellationToken)
        {
            
            var rst = await _ctx.Update_Sms(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
