﻿using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IServices.IApp.ISms;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using System.Threading.Tasks;
using System.Threading;

namespace Farakonesh.API.Controllers.App.Queue
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ShiftController : ControllerBase
    {
        private readonly IShiftContext _shiftContext;
        public ShiftController(IShiftContext shiftContext)
        {
            _shiftContext = shiftContext;
        }
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] Get_Shifts.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _shiftContext.Get_Shifts(inputs, cancellationToken);
            return Ok(rst);
        }
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_Shift.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _shiftContext.Insert_Shift(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_Shift.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _shiftContext.Update_Shift(inputs, cancellationToken);
            return Ok(rst);
        }


        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_Shift.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _shiftContext.Delete_Shift(inputs, cancellationToken);
            return Ok(rst);
        }

    }
}
