﻿using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading.Tasks;
using System.Threading;

namespace Farakonesh.API.Controllers.App.Queue
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ShiftDetailController : ControllerBase
    {
        private readonly IShiftContext _shiftContext;
        public ShiftDetailController(IShiftContext shiftContext)
        {
            _shiftContext = shiftContext;
        }
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] Get_ShiftDetails.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _shiftContext.Get_ShiftDetails(inputs, cancellationToken);
            return Ok(rst);
        }
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_ShiftDetail.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _shiftContext.Insert_ShiftDetail(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_ShiftDetail.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _shiftContext.Update_ShiftDetail(inputs, cancellationToken);
            return Ok(rst);
        }


        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_ShiftDetails.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _shiftContext.Delete_ShiftDetails(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
