﻿using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading.Tasks;
using System.Threading;

namespace Farakonesh.API.Controllers.App.Queue
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ShiftUserController : ControllerBase
    {
        private readonly IShiftContext _shiftContext;
        public ShiftUserController(IShiftContext shiftContext)
        {
            _shiftContext = shiftContext;
        }
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] Get_ShiftUser.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _shiftContext.Get_ShiftUser(inputs, cancellationToken);
            return Ok(rst);
        }
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_ShiftUser.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _shiftContext.Insert_ShiftUser(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_ShiftUser.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _shiftContext.Delete_ShiftUser(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
