﻿using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading.Tasks;
using System.Threading;

namespace Farakonesh.API.Controllers.App.Queue
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class TelegramBotChannelConnectionActionController : ControllerBase
    {
        private readonly IQueueContext _queueContext;
        public TelegramBotChannelConnectionActionController(IQueueContext queueContext)
        {
            _queueContext = queueContext;
        }
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] Get_TelegramBotChannelConnectionAction.Inputs inputs, CancellationToken cancellationToken)
        {

            var rst = await _queueContext.Get_TelegramBotChannelConnectionAction(inputs, cancellationToken);
            return Ok(rst);
        }
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_TelegramBotChannelConnectionAction.Inputs inputs, CancellationToken cancellationToken)
        {

            var rst = await _queueContext.Insert_TelegramBotChannelConnectionAction(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_TelegramBotChannelConnectionAction.Inputs inputs, CancellationToken cancellationToken)
        {

            var rst = await _queueContext.Update_TelegramBotChannelConnectionAction(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_TelegramBotChannelConnectionAction.Inputs inputs, CancellationToken cancellationToken)
        {

            var rst = await _queueContext.Delete_TelegramBotChannelConnectionAction(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
