﻿using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading.Tasks;
using System.Threading;

namespace Farakonesh.API.Controllers.App.Queue
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class TelegramBotChannelController : ControllerBase
    {
        private readonly IQueueContext _queueContext;
        public TelegramBotChannelController(IQueueContext queueContext)
        {
            _queueContext = queueContext;
        }
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] Get_TelegramBotChannel.Inputs inputs, CancellationToken cancellationToken)
        {

            var rst = await _queueContext.Get_TelegramBotChannel(inputs, cancellationToken);
            return Ok(rst);
        }
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_TelegramBotChannel.Inputs inputs, CancellationToken cancellationToken)
        {

            var rst = await _queueContext.Insert_TelegramBotChannel(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_TelegramBotChannel.Inputs inputs, CancellationToken cancellationToken)
        {

            var rst = await _queueContext.Update_TelegramBotChannel(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_TelegramBotChannel.Inputs inputs, CancellationToken cancellationToken)
        {

            var rst = await _queueContext.Delete_TelegramBotChannel(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
