﻿using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading.Tasks;
using System.Threading;
using Microsoft.AspNetCore.Authorization;
using Farakonesh.Shared.Exceptions;
using Microsoft.Extensions.Configuration;
using Farakonesh.API.Filters;

namespace Farakonesh.API.Controllers.App.Queue
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class TelegramStateController : ControllerBase
    {
        private readonly IQueueContext _queueContext;
        public TelegramStateController(IQueueContext queueContext)
        {
            _queueContext = queueContext;
        }
        /// <summary>
        /// دریافت آخرین وضعیت چت تلگرام
        /// </summary>
        /// <param name="auth"></param>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        /// <exception cref="InternalServiceException"></exception>
        [HttpPut]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> Get([FromBody] Get_TelegramState.Inputs inputs, CancellationToken cancellationToken)
        {
            
            var rst = await _queueContext.Get_TelegramState(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی وضعیت چت تلگرام
        /// </summary>
        /// <param name="auth"></param>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        /// <exception cref="InternalServiceException"></exception>
        [HttpPut]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> Update([FromBody] Update_TelegramState.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _queueContext.Update_TelegramState(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
