﻿using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Commands.Services.HttpRequest;

namespace Farakonesh.API.Controllers.App.Queue
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class WhatsappController : ControllerBase
    {
        private readonly IWhatsappHelper _whatsappHelper;
        public WhatsappController(IWhatsappHelper whatsappHelper)
        {
            _whatsappHelper = whatsappHelper;
        }
        /// <summary>
        /// دریافت سابقه پیغام های واتساپ ، از وب سرویس اصلی - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetHistory([FromBody] GetMeWhatsappMessagesCommand command, CancellationToken cancellationToken)
        {

            var rst = await _whatsappHelper.GetMeWhatsappMessages(command, cancellationToken);
            return Ok(rst);
        }
    }
}
