﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase.IReport;
using Farakonesh.Logic.IServices.IApp.Idbo;
using Farakonesh.Models.Database.StoredProcedures.App.Report;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Report
{
    /// <summary>
    /// سرویس های گزارش داشبورد
    /// </summary>
    [Route("api/[controller]/[action]")]
	[ApiController]
	public class DashboardController : ControllerBase
    {
		private readonly IReportContext _reportContext;
        private readonly IDasboardService _dasboardService;
        public DashboardController(IReportContext reportContext, IDasboardService dasboardService) {
		_reportContext= reportContext;
		_dasboardService= dasboardService;
		}
		/// <summary>
		/// دریافت تعداد عملیات های انجام شده در سیستم - به تفکیک عملیات - مثل تعداد تراکنش های موفق و غیره
		/// </summary>
		/// <param name="inputs"></param>
		/// <returns></returns>
		[HttpPut]
		public async Task<IActionResult> GetCountAll([FromBody] GetCountAllDashboard.Inputs inputs, CancellationToken cancellationToken)
		{
			var rst = await _reportContext.GetCountAllDashboard(inputs, cancellationToken);
			return Ok(rst);
		}
        [HttpGet]
		[AllowAnonymous]
        public async Task<IActionResult> Get(CancellationToken cancellationToken)
        {
            var rst = await _dasboardService.getDashboardContent(cancellationToken);
            return Ok(rst);
        }
    }
}
