﻿using Farakonesh.Logic.IDatabase.IReport;
using Farakonesh.Models.Database.StoredProcedures.App.Report;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Report
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class RfmController : ControllerBase
    {
        private readonly IReportContext _reportContext;
        public RfmController(IReportContext reportContext)
        {
            _reportContext = reportContext;
        }

        [HttpPut]
        public async Task<IActionResult> GetSummary([FromBody] GetRfmSummary.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _reportContext.GetRfmSummary(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        public async Task<IActionResult> GetUserCategory([FromBody] GetUserRFMCategoryReport.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _reportContext.GetUserRFMCategoryReport(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
