﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.IReport;
using Farakonesh.Models.Database.StoredProcedures.App.Report;
using System.Threading.Tasks;
using System.Threading;

namespace Farakonesh.API.Controllers.App.Report
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class TransactionsReportController : ControllerBase
    {
        private readonly IReportContext _reportContext;
        public TransactionsReportController(IReportContext reportContext)
        {
            _reportContext = reportContext;
        }

        [HttpPut]
        public async Task<IActionResult> GetReportPaymentLink([FromBody] GetPaymentLinkHistoryReport.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _reportContext.GetPaymentLinkHistoryReport(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        public async Task<IActionResult> GetReportAccountNumberHistory([FromBody] GetAccountNumberHistoryReport.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _reportContext.GetAccountNumberHistoryReport(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        public async Task<IActionResult> GetTransactionReport([FromBody] GetTransactionReport.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _reportContext.GetTransactionReport(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
