﻿using Farakonesh.Logic.IDatabase.IReport;
using Farakonesh.Models.Database.StoredProcedures.App.Report;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Report
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class UserReportController : ControllerBase
    {
        private readonly IReportContext _reportContext;
        public UserReportController(IReportContext reportContext)
        {
            _reportContext = reportContext;
        }

        [HttpPut]
        public async Task<IActionResult> GetUserReport([FromBody] GetUserReport.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _reportContext.GetUserReport(inputs, cancellationToken);
            return Ok(rst);
        }
    }

}
