﻿using Farakonesh.Logic.IDatabase.IReport;
using Farakonesh.Models.Database.StoredProcedures.App.Report;
using Farakonesh.Models.Database.StoredProcedures.App.User.Wallet;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Report
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class WalletReportController : ControllerBase
    {
        private readonly IReportContext _reportContext;
        public WalletReportController(IReportContext reportContext)
        {
            _reportContext = reportContext;
        }
        /// <summary>
        /// گزارش خلاصه واریز و برداشت کیف پول
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetSummary([FromBody] GetSummaryWallet.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _reportContext.GetSummaryWallet(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
