﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.IReport;
using Farakonesh.Models.Database.StoredProcedures.App.Report;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Report
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class WareHouseController : ControllerBase
    {
        private readonly IReportContext _reportContext;
        public WareHouseController(IReportContext reportContext)
        {
            _reportContext = reportContext;
        }
        /// <summary>
        /// دریافت گزارش های کلی ، مجموع خرید و فروش ارز در سیستم
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Get([FromBody] Get_GeneralReportWarehouse_Admin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _reportContext.Get_GeneralReportWarehouse_Admin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت گزارش موجودی انبار ارزی - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetInventoryReport([FromBody] Get_CurrencyWarehouse_Report_Admin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _reportContext.Get_CurrencyWarehouse_Report_Admin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت گزارش موجودی جمع انبار های ارز - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetSumInventoryReport([FromBody] Get_CurrencyWarehouse_Report_Sum_Admin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _reportContext.Get_CurrencyWarehouse_Report_Sum_Admin(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
