﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.Database.Order;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IServices.IApp.ISystems;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Systems
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class BalanceSystemsController : ControllerBase
    {
        private readonly IBalanceSystems _balanceSystems;
        public BalanceSystemsController(IBalanceSystems balanceSystems)
        {
            _balanceSystems = balanceSystems;
        }
        [HttpPut]
        public async Task<IActionResult> Get(CancellationToken cancellationToken)
        {
            var rst = await _balanceSystems.getBalanceSystems(cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        public async Task<IActionResult> CheckConnectionMail(CancellationToken cancellationToken)
        {
            var rst = await _balanceSystems.CheckConnectionMail(cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        public async Task<IActionResult> CheckConnectionFileManager(CancellationToken cancellationToken)
        {
            var rst = await _balanceSystems.CheckConnectionFileManager(cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        public async Task<IActionResult> CheckConnectionInquiryJibit(CancellationToken cancellationToken)
        {
            var rst = await _balanceSystems.CheckConnectionInquiryJibit(cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        public async Task<IActionResult> CheckConnectionZarinpal(CancellationToken cancellationToken)
        {
            var rst = await _balanceSystems.CheckConnectionZarinpal(cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        public async Task<IActionResult> CheckVolumeFileManager(CancellationToken cancellationToken)
        {
            var rst = await _balanceSystems.CheckVolumeFileManager(cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        public async Task<IActionResult> GetPlaneForInquiryArvanCloude(CancellationToken cancellationToken)
        {
            var rst = await _balanceSystems.GetPlaneForInquiryArvanCloude(cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        public async Task<IActionResult> GetAccountInfoKavenegarAlarm(CancellationToken cancellationToken)
        {
            var rst = await _balanceSystems.GetAccountInfoKavenegarAlarm(cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        public async Task<IActionResult> GetAccountBalancePayeerAlarm(CancellationToken cancellationToken)
        {
            var rst = await _balanceSystems.GetAccountBalancePayeerAlarm(cancellationToken);
            return Ok(rst);
        }

      

    }
}
