﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.ActionLog;
using Farakonesh.Models.Database.StoredProcedures.App.User.Address;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.User
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ActionLogsController : ControllerBase
    {
        private readonly IUserContext _ctx;
        public ActionLogsController(
        IUserContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست لاگ های کاربران - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] Get_ActionLogs.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_ActionLogs(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
