﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.Address;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.Commands.Services.HttpRequest;
using Farakonesh.Logic.Services.App.User;
using Farakonesh.Logic.IServices.IApp.IUser;

namespace Farakonesh.API.Controllers.App.User
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class AddressController : ControllerBase
    {
        private readonly IUserContext _ctx;
        private readonly IAddressContext _addressContext;
        private readonly IAddressService _addressService;
        public AddressController(
        IUserContext ctx, IUserServices userServices, IAddressService addressService,
        IAddressContext addressContext)
        {
            _ctx = ctx;
            _addressContext = addressContext;
            _addressService = addressService;
        }
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> Get([FromBody] GetAddress.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _addressContext.GetAddress(inputs, cancellationToken);
            return Ok(rst);
        }
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetByAdmin([FromBody] GetAddressByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _addressContext.GetAddressByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> AddAddress([FromBody] Insert_Address.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _addressContext.Insert_Address(inputs, cancellationToken);
            return Ok(rst);
        }
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> AddAddressByAdmin([FromBody] Insert_AddressByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _addressContext.Insert_AddressByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> UpdateAddress([FromBody] Update_Address.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _addressContext.Update_Address(inputs, cancellationToken);
            return Ok(rst);
        }
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> UpdateAddressByAdmin([FromBody] Update_AddressByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _addressContext.Update_AddressByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات آدرس با استعلام کد پستی - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetAddressByPostalCode([FromBody] GetAddressByPostalCodeCommand inputs, CancellationToken cancellationToken)
        {
            var rst = await _addressService.GetAddressByPostalCodeByCustomer(inputs, _ctx, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات آدرس با استعلام کد پستی - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAddressByPostalCodeByAdmin([FromBody] GetAddressByPostalCodeCommand inputs, CancellationToken cancellationToken)
        {
            var rst = await _addressService.GetAddressByPostalCode(inputs, _ctx, cancellationToken);
            return Ok(rst);
        }

        [HttpDelete]
        [CustomersAuth]
        public async Task<IActionResult> DeleteAddress([FromQuery] Delete_Address.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _addressContext.Delete_Address(inputs, cancellationToken);
            return Ok(rst);
        }
        [HttpDelete]
        [CustomersAuth]
        public async Task<IActionResult> DeleteAddressByAdmin([FromQuery] Delete_AddressByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _addressContext.Delete_AddressByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
