﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Models.Database.StoredProcedures.App.User.Wallet;
using System.Threading.Tasks;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IDatabase.idbo;
using System.Threading;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Commands.Services;

namespace Farakonesh.API.Controllers.App.User
{
    /// <summary>
    /// سرویس های کار با فرآیند تسویه حساب
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class CashController : ControllerBase
    {
        private readonly IWalletContext _ctx;
        private readonly IWalletService _walletService;
        public CashController(
            IWalletContext ctx, IWalletService walletService)
        {
            _ctx = ctx;
            _walletService = walletService;
        }
        /// <summary>
        /// درخواست لیست تسویه حساب ها - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetAll([FromBody] GetCashByCustomer.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetCashByCustomer(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست تسویه حساب ها - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAllByAdmin([FromBody] GetCash.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetCash(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی وضعیت درخواست تسویه حساب - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> UpdateStatus([FromBody] Change_Status_Cash.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Change_Status_Cash(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// افزودن درخواست تسویه حساب - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> Save([FromBody] Insert_CashByCustomer.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_CashByCustomer(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// افزودن درخواست تسویه حساب - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveByAdmin([FromBody] InsertCashByAdminCommand inputs, CancellationToken cancellationToken)
        {
            var rst = await _walletService.insertCashByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف درخواست تسویه حساب - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_Cash.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_Cash(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
