﻿using Farakonesh.API.Filters;
using Farakonesh.Commands.Services.User;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using Farakonesh.Models.Database.StoredProcedures.App.User.Wallet;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.User
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ClientTrackingDataExternalController : ControllerBase
    {
        private readonly IUserContext _ctx;
        private readonly IHttpRequestAnalytics _httpRequestAnalytics;
        public ClientTrackingDataExternalController(IUserContext ctx, IHttpRequestAnalytics httpRequestAnalytics)
        {
            _ctx = ctx;
            _httpRequestAnalytics = httpRequestAnalytics;
        }
        /// <summary>
        /// ثبت اطلاعات مارکتینگ خارجی کاربر - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> Save([FromBody] Insert_ClientTrackingDataExternal.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_ClientTrackingDataExternal(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات مارکتینگ خارجی کاربر - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> Get([FromBody] Get_ClientTrackingDataExternal.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_ClientTrackingDataExternal(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// افزودن دیتا به گوگل آنالیتیکس - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> Collect([FromBody] CollectAnalyticsCommand inputs, CancellationToken cancellationToken)
        {
            var rst = await _httpRequestAnalytics.Collect(inputs, cancellationToken);
            return Ok(rst);
        }
        
    }
}
