﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Commands.Services;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.IServices.IApp.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.Company;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.User
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class CompanyClientController : ControllerBase
    {
        private readonly ICompanyContext _ctx;
        private readonly IUserServices _userServices;
        public CompanyClientController(ICompanyContext ctx, IUserServices userServices)
        {
            _ctx = ctx;
            _userServices = userServices;
        }
        /// <summary>
        /// دریافت کاربران منتصب به کمپانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CompanyAuth]
        public async Task<IActionResult> Get([FromBody] GetCompanyClientList.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetCompanyClientList(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت کاربران منتصب به کمپانی توسط ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetByAdmin([FromBody] GetCompanyClientListByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetCompanyClientListByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// انتصاب کاربر به کمپانی
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [CompanyAuth]
        public async Task<IActionResult> Save([FromBody] InsertClientByCompanyCommand command, CancellationToken cancellationToken)
        {
            var rst = await _userServices.insertClientByCompany(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// انتصاب کاربر زیر مجموعه به کمپانی توسط راهبر
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveByAdmin([FromBody] Insert_CompanyClientByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_CompanyClientByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف انتصاب کاربر از کمپانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        [CompanyAuth]
        public async Task<IActionResult> Delete([FromQuery] Delete_CompanyClient.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_CompanyClient(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف انتصاب کاربر از زیر مجموعه ی کمپانی توسط راهبر
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> DeleteByAdmin([FromQuery] Delete_CompanyClientByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_CompanyClientByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
